require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/cumine.zip"),
	Asset("ATLAS", "images/inventoryimages/rabbitwheel.xml")
}

local prefabs =
{
    "carrot",
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    inst.components.lootdropper:DropLoot()
    local fx = SpawnPrefab("collapse_small")
    fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    fx:SetMaterial("wood")
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("idle")
end

local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
	
end
local function OnRefuseItem(inst, giver, item)
    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
end
local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .2)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 3, 3 )
	local work = 0
    inst.AnimState:SetBank("cumine")
    inst.AnimState:SetBuild("cumine")
    inst.AnimState:PlayAnimation("idle")
	
    MakeSnowCoveredPristine(inst)
    inst:AddTag("structure")
    inst:AddTag("sign")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("talker")
--------------------------------
------------交易组件------------
     inst:AddComponent("trader")
	 inst.components.trader:SetAcceptTest(function(inst,item)
	 if item.prefab == "carrot" and work == 0
	 then
	 return true
	 end
	 return false
	 end)
------提取系统-----------------
local function OnGetItemFromPlayer(inst, giver, item)
 if item.prefab == "carrot" then
	work = 30
    local say = "开始工作"
	return say
    end
end
--------------------------------
	inst:AddComponent("workable")
	
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(75)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
	inst:AddComponent("inventory")
    inst:AddComponent("lootdropper")
	inst:ListenForEvent("onbuilt", onbuilt)
    inst.components.trader.onaccept = OnGetItemFromPlayer
	MakeHauntableWork(inst)
	inst:AddComponent("inspectable")
--工作
     inst:DoPeriodicTask(16, function(inst)
	 local x, y, z = inst.Transform:GetWorldPosition()
y = 1
x = x+2
	if work >= 0 and work ~= 0 then
	inst.AnimState:PlayAnimation("work",true)
	local n = math.random(0,50)
	if n == 0 then  SpawnPrefab("coherer").Transform:SetPosition(x, y, z) end
	if n == 1 then  SpawnPrefab("cu").Transform:SetPosition(x, y, z) end
	if n == 10 then  SpawnPrefab("cu").Transform:SetPosition(x, y, z) end
	if n == 5 then  SpawnPrefab("flint").Transform:SetPosition(x, y, z) end
	if n == 20 then  SpawnPrefab("flint").Transform:SetPosition(x, y, z) end
	if n == 6 then  SpawnPrefab("rocks").Transform:SetPosition(x, y, z) end
	if n == 7 then  SpawnPrefab("rocks").Transform:SetPosition(x, y, z) end
	if n == 8 then  SpawnPrefab("rocks").Transform:SetPosition(x, y, z) end
	if n == 2 then  SpawnPrefab("nitre").Transform:SetPosition(x, y, z) end
	if n == 3 then  SpawnPrefab("nitre").Transform:SetPosition(x, y, z) end
	if n == 4 then  SpawnPrefab("nitre").Transform:SetPosition(x, y, z) end
	work = work - 1
	end
	if work == 0  then
	inst.AnimState:PlayAnimation("idle",true)
	end
	if work <= 0 then work = 0
 end
 end)
		----保存载入
local function onsave(inst, data)
    data.work = work
end
 local function onload (inst, data)
    if data ~= nil
     then
		work = data.work
		print(tostring(work));
	if work >=1 and work ~=0  then
    inst.AnimState:PlayAnimation("work",true)  end
	if work == 0 then
    inst.AnimState:PlayAnimation("idel",true) end
     end
end	
inst.OnSave = onsave
inst.OnLoad = onload
return inst
end
return Prefab("cumine", fn, assets, prefabs),
MakePlacer("cumine_placer", "cumine", "cumine", "idle")